
#ifndef _1_CRYS_ATP_TST_DES_Acceptance_h_H
#define _1_CRYS_ATP_TST_DES_Acceptance_h_H

/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */
#include "CRYS.h"
#include "CRYS_ATP_TST_Defines.h"
#if TST_USE_DES_DATA/*In case no test vectors are selected - code disabled*/
#ifdef __cplusplus
extern "C"
{
#endif

  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Tue Dec 14 15:03:14 2004
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_ATP_TST_DES_Acceptance.h#1:incl:1
   *  \author doronp
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/******** Defines **********/
/******** Enums ************/
/******** Typedefs  **********/
/******** Structs  **********/
typedef struct TST_DES_TestDataStruct{	
	char					    TST_Name[TST_NAME_STRING_LEN];
	CRYS_DES_Key_t 				TST_Key;
	CRYS_DES_NumOfKeys_t		TST_NumOfKeys;
	CRYS_DES_Iv_t				TST_IvCounter;
	DxUint8_t 					TST_input_data[TST_DES_DATA_VEC_SIZE_IN_BYTS];
	DxUint8_t 					TST_output_data[TST_DES_DATA_VEC_SIZE_IN_BYTS];
	DxUint8_t 					TST_Expected_output_data[TST_DES_DATA_VEC_SIZE_IN_BYTS];
	DxUint16_t					TST_dataSize;	
	CRYS_DES_OperationMode_t	TST_OperationMode;
} TST_DES_TestDataStruct;

/******** Public Variables ********/


/******** Public Functions ********/
/***************************
 * Function Name:                                                           
 * 	CRYS_ATP_TST_DES_Acceptance_NON_integrated 		
 * 
 * Inputs:
 * 	None
 *
 * Outputs:
 * 	CRYSError_t - Function error return		    					  		
 *
 * Description:																	
 * 	This function Is a Acceptance test for DES non integrated API's							
 * 	This function Encrypts and Decrypts known vectors using DES
 *  DES modes                   - CBC/ECB
 * 	Vector sizes used (in bytes) - 16/32/512/1536							
 * 	Key Size used (in bits)	    - 128/192/256								
 * 	This also outputs the results to an output buffer or the same input buffer
 * Algorithm:		
 * 1. Call the CRYS_DES_Init function to start the encryption/decryption process
 * 2. Call the CRYS_DES_Block - This function is called N times
 *                              (N = number of blocks in data)
 * 3. Call the CRYS_DES_Free to end the encryption/decryption process 
 * 4. Compare the outputted result to the expected one													
 *
 **************************/
CRYSError_t CRYS_ATP_TST_DES_Acceptance_NON_integrated ( void );

/***************************
 * Function Name:                                                           
 * 	CRYS_ATP_TST_DES_Acceptance_Integrated 		
 * 
 * Inputs:
 * 	None
 *
 * Outputs:
 * 	CRYSError_t - Function error return		    					  		
 *
 * Description:																	
 * 	This function Is a Acceptance test for DES integrated API							
 * 	This function Encrypts and Decrypts known vectors using DES
 *  DES modes                   - CBC/ECB
 * 	Vector sizes used (in bytes) - 16/32/512/1536							
 * 	Key Size used (in bits)	    - 128/192/256								
 * 	This also outputs the results to an output buffer or the same input buffer
 * Algorithm:		
 * 1. Call the CRYS_DES function to use the DES encryption/decryption process
 * 2. Compare the outputted result to the expected one													
 *
 **************************/	
CRYSError_t CRYS_ATP_TST_DES_Acceptance_Integrated ( void );
 
#ifdef __cplusplus
}
#endif

#endif

#endif


